/*
  name: tools/libmaker/arcslibmakerparser.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include "arcslibmakerparser.h"
#include <QFile>
#include <QTextStream>
#include <iostream>


ARCSLibMakerParser::ARCSLibMakerParser()
{

}

void ARCSLibMakerParser::clear()
{
     headers.clear();
     components.clear();
     families.clear();
     types.clear();
     doc.clear();
}


bool ARCSLibMakerParser::parseFile()
{
     if (fileName.isEmpty())
	  return false;

     QFile file(fileName);
     if (!file.open(QIODevice::ReadOnly))
         return false;

          QString error;
     int line, col;



     if (!doc.setContent(&file, &error, &line, &col))
     {
          std::cerr << "[ARCS libmaker] Error in parsing xml file" << std::endl;
       std::cerr << "" << "[" << line << "," << col << "] "
              << qPrintable(error) <<  std::endl;
         file.close();
         return false;
     }
     file.close();

     parseHeaders();
     parseComponents();
     parseFamilies();
     parseTypes();

     return true;
}


bool ARCSLibMakerParser::writeFile()
{
     if (fileName.isEmpty())
	  return false;

     QFile data(fileName);

     if (data.open(QFile::WriteOnly | QFile::Truncate)) 
     {
	  QTextStream out(&data);
	  doc.save(out, 4);
	  return true;
     }

     return false;
}


void ARCSLibMakerParser::parseSection(QString secname,QStringList & strlist)
{
     if (doc.isNull())
	  return ;

     QDomNodeList lst = doc.elementsByTagName(secname);

     for (unsigned int i = 0; i < lst.length(); i++)
     {
	  QDomNode node = lst.item(i).attributes().namedItem("name");
	  if (node.isAttr())
	       strlist << node.nodeValue();
     }
}


void ARCSLibMakerParser::parseTypes()
{
     if (doc.isNull())
       return ;

     QDomNodeList lst = doc.elementsByTagName("type");

     for (unsigned int i = 0; i < lst.length(); i++)
     {
       QDomNode nodeName = lst.item(i).attributes().namedItem("name");
       QDomNode nodeWrapper = lst.item(i).attributes().namedItem("wrapper");
       if (nodeName.isAttr() && nodeWrapper.isAttr())
       {
            types << ARCSTypeWrapper(nodeName.nodeValue(), nodeWrapper.nodeValue()) ;
            std::cout << qPrintable(nodeName.nodeValue()) << ", " << qPrintable(nodeName.nodeValue()) << std::endl;
       }
       else
       {
            types << ARCSTypeWrapper(nodeName.nodeValue());
            std::cout << qPrintable(nodeName.nodeValue()) << std::endl;
       }


     }
}
