/*
  name: tools/pkg/arcsdownloader.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSDOWNLOADER_H__
#define __ARCSDOWNLOADER_H__

#include <QObject>

#include <QNetworkProxy>
#include <QSslError>
#include <QStringList>

class QNetworkReply;
class QAuthenticator;
class QNetworkAccessManager;
class QEventLoop;


class ARCSDownloader : public QObject
{
    Q_OBJECT
public:
    explicit ARCSDownloader(QObject *parent = 0);

signals:
    void finished();

public slots:
    void download(QString s);

private slots:
    void replyFinished(QNetworkReply* reply);
    void authenticateToSite(QNetworkReply* reply, QAuthenticator*auth);
    void authenticateToProxy(const QNetworkProxy & proxy, QAuthenticator * auth );
    void sslErrors ( QNetworkReply * reply, const QList<QSslError> & errors );

    void setProgress(qint64 received, qint64 total);

private:
    void authenticate(QAuthenticator* auth);
    QNetworkAccessManager* manager;
    QEventLoop* eventLoop;
    QString filename;
    QList<QSslError> cachedSslErrors;
};

#endif // __ARCSDOWNLOADER_H__
