/*
  name: tools/pkg/arcspackagemanager.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSPACKAGEMANAGER_H__
#define __ARCSPACKAGEMANAGER_H__

#include <QString>
#include <QStringList>
#include <QSettings>
#include <QHash>
#include <QFile>
#include <iostream>


class ARCSDownloader;

class ARCSPackageManager
{
public:
    ARCSPackageManager();
    ~ARCSPackageManager();

    void setSetting(QString s,QString value)
    {
        if (hS.contains(s))
            hS[s]=value;
    }

    bool checkSettings();
    void storeSettings();
    void displaySettings();
    bool hasSetting(QString key)
    {
        if (!hS.contains(key))
            return false;
        return !hS[key].isEmpty();
    }

    void buildRepository();
    void installLibrary(QString libraryName);
    void installAll();

    void run() ;


private:
    void parseRepositoryFile(QFile &data);

    QStringList getRelatedFiles(QString libraryPath);

    void storeSetting(QString key) {
        if (!hS[key].isEmpty()) settings.setValue("pkg/"+ key, hS[key]);
    }
    void fetchSetting(QString key,QString defValue = QString::null) {
        hS[key] = settings.value("pkg/"+key, defValue).toString();
    }

    void displaySetting(QString key){
        std::cout << "  - " << qPrintable((key+":").leftJustified(20))
                  << qPrintable((hS[key].isEmpty())?"## NOT SET ##":hS[key])
                  << std::endl;
    }

    QStringList libs;
    QStringList libPaths;
    QSettings settings;
    ARCSDownloader* ad;
    QHash<QString,QString> hS;
};

#endif // __ARCSPACKAGEMANAGER_H__
