/*
  name: tools/wizard/pathvalidator.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __PATHVALIDATOR_H__
#define __PATHVALIDATOR_H__

#include <QValidator>
#include <QFileInfo>
#include <QDir>
#include <QStringList>
#include <QRegExp>

class PathValidator : public QValidator
{
public:
     PathValidator(QObject* parent) : QValidator(parent) { fileExists = true; }

     virtual State validate(QString & str, int &) const
     {
          if (fileExists)
          {
               if (!QFileInfo(str).canonicalFilePath().isEmpty())
               {
                    if (!filter.isEmpty())
                    {
                         bool res = false;
                         for (int i=0; i < filter.count(); i++)
                         {
                              QRegExp regExp(filter[i]);
                              regExp.setPatternSyntax(QRegExp::Wildcard);
                              res = res | regExp.exactMatch(QFileInfo(str).fileName());
                         }
                         if (res)
                              return QValidator::Acceptable ;
                    }
                    else
                         return QValidator::Acceptable ;
               }
          }
          else
          {
               if (!QFileInfo(str).dir().canonicalPath().isEmpty())
               {
                    if (!filter.isEmpty())
                    {
                         bool res = false;
                         for (int i=0; i < filter.count(); i++)
                         {
                              QRegExp regExp(filter[i]);
                              regExp.setPatternSyntax(QRegExp::Wildcard);
                              res = res | regExp.exactMatch(QFileInfo(str).fileName());
                         }
                         if (res)
                              return QValidator::Acceptable ;
                    }
                    else
                         return QValidator::Acceptable;
               }
          }

          if (!QFileInfo(str).dir().canonicalPath().isEmpty())
               return QValidator::Intermediate ;
          return QValidator::Invalid ;
     }

     void setFilter(QStringList f) { filter = f; }
     void setFileExists(bool f) { fileExists = f; }
     bool getFileExists() { return fileExists; }

private:
     QStringList filter;
     bool fileExists;
};


#endif // __PATHVALIDATOR_H__
