arcs_module(function (ARCS) {
    var Inertial = ARCS.Component.create( function() {
        var self = this;

        var handleOrientation = function (event) {
            console.log("sending orientation");
            self.emit("sendOrientation",event);
        };
        
        var handleMotion = function(event) {
            console.log("sending motion");
            self.emit("sendAcceleration",event.acceleration);
            self.emit("sendAccelerationIncludingGravity", event.accelerationIncludingGravity);
            self.emit("sendRotationRate",event.rotationRate); 
        };
        
        
        this.start = function() {
            if (window.DeviceOrientationEvent) {
                console.log("Device orientation capability detected");
                window.addEventListener("deviceorientation", handleOrientation, true);
                //window.ondeviceorientation = handleOrientation;
            } else {
                console.log("[Inertial]","no device orientation API");
            }
        
            if (window.DeviceMotionEvent) {
                console.log("Device motion capability detected");
                window.addEventListener("devicemotion", handleMotion, true);
            } else {
                console.log("[Inertial]","no device motion API");
            }
        };
        
        },
        ["start"],
        ["sendOrientation","sendAcceleration","sendAccelerationIncludingGravity", "sendRotationRate"]
    );
    
    
    
 
    
    return { Inertial : Inertial }; 
});