arcs_module(
    function (ARCS) {
        var ScoreBoard;

        ScoreBoard = ARCS.Component.create(
            function (score_ids) {
                var score = [0,0];
                var redScore = document.getElementById(score_ids[0]);
                var yellowScore = document.getElementById(score_ids[1]);
                
                //console.log("score_ids", score_id1, score_id2);
                
                var updateScore = function () {
                    yellowScore.innerHTML = score[0];
                    redScore.innerHTML = score[1];
                };
                
                this.resetScore = function () {
                    score = [0,0];
                    updateScore();
                };
                
                this.player1IsScoring = function () {
                    score[0]++;
                    updateScore();
                };
                
                this.player2IsScoring = function () {
                    score[1]++;
                    updateScore();
                };
                
                this.updateValues = function( a, b) {
                    score[0] = a; 
                    score[1] = b;
                    updateScore();
                };
            },
            ['resetScore','updateValues', 'player1IsScoring', 'player2IsScoring'],
            []
        );
    


        return { ScoreBoard: ScoreBoard };
    }
);