/******************************************************************************
 * Invocation implementation
 * ***************************************************************************/
/**
 * Defines an invocation
 * @param destination {object} component on which to perform invocation
 * @param slot {string} name of the slot 
 * @param value {mixed} value passed to the invoked slot
 * @constructor
 */
ARCS.Invocation = function (destination, slot, value) {
    this.getDestination = function () {
        return destination;
    };
    
    this.getSlot = function () {
        return slot;
    };
    
    this.getValue = function () {
        return value;
    };
    
    this.invoke = function () {
        var func = destination[slot];
        if (func === undefined) {
                console.error("Undefined slot %s of component %s", slot, destination);
                return;
        } 
        func.apply(destination, value);
    };
};
/**
 * Helper function that casts an invocation from a description 
 * @param obj {object} a raw description of the invocation
 * @param context {object} the context in which this invocation takes place.
 * @return an invocation
 */
ARCS.Invocation.cast = function (obj, context) {
    return new ARCS.Invocation(context[obj.destination].instance, obj.slot, obj.value);
};

/*ARCS.Invocation.revert = function(obj, context) {
    return {
        destination: context
        
    };
    
};*/


ARCS.Invocation.PRE_CONNECTION = 0;
ARCS.Invocation.POST_CONNECTION = 1;
ARCS.Invocation.CLEAN_UP = 2;