ARCSEditor.InvocationDialogData = function(app) {
    var application = app;
    var sheetId;
    var invocationType;
    var invocationObject;
    
    var destinationElement;
    var slotElement;

    var addInvocation = function () {
        var destination = document.getElementById("invocation-destination");
        var slot = document.getElementById("invocation-slot");
        var value = document.getElementById("invocation-value");
        ARCSEditor.addInvocation(sheetId, invocationType, 
            { destination: destination.value, slot: slot.value, value: value.value}
        );   
        ARCSEditor.Dialog.close();        
    };
    
    
    var storeDestination = function (elt) { destinationElement = elt; };
    var storeSlot = function (elt) { slotElement = elt; };
    var populateSlots = function () {        
        return function(elt) { 
            ARCSEditor.populateSlots(slotElement, destinationElement.value); 
        };
    };
    

    var populateSelect = function(text) {
        return function (elt) {
            select = elt;
            elt.innerHTML = '';
            option = document.createElement("option");
            option.text = text;
            elt.add(option);
        };
    };
    
    var changeInvocation = function () {
        var value = document.getElementById("invocation-value");
        invocationObject.value = value.value;        
        ARCSEditor.changeInvocation(sheetId, invocationType, invocationObject);
        
        ARCSEditor.Dialog.close();
    };
        
    this.selector = "#form-invocation";
    
    this.init = function (sheetName,type,invocation) {
        sheetId = sheetName;
        invocationType = type;
        
        if (invocation === undefined) {
            this.replacements = [
                { selector: "#invocation-destination", run: ARCSEditor.populateComponents },
                { selector: "#invocation-destination", run: storeDestination },
                { selector: "#invocation-destination", key: "onchange", value: populateSlots() },
                { selector: "#invocation-slot", run: storeSlot },
                { selector: "#invocation-slot", run: populateSlots() },
                { selector : "#ok", key: "onclick", value: addInvocation },
                { selector : "#cancel", key: "onclick", value: ARCSEditor.Dialog.close }
            ];
        } else {        
            invocationObject = invocation;
            this.replacements = [
                { selector: "#invocation-destination", run: populateSelect(invocation.destination) },
                { selector: "#invocation-destination", key: "disabled", value: true },
                { selector: "#invocation-slot", run: populateSelect(invocation.slot) },
                { selector: "#invocation-slot", key: "disabled", value: true },
                { selector: "#invocation-value", key: "value", value: invocation.value },
                { selector : "#ok", key: "onclick", value: changeInvocation },
                { selector : "#cancel", key: "onclick", value: ARCSEditor.Dialog.close }            
            ];
        }
    };
    
};