/**
 * definition of the main module function: 
 * it takes an anonymous function as a parameter
 * the anonymous function has one parameter: the object encompassing 
 * ARCS definitions (in order to able to use ARCS.Component.create, ...)
 * @param moduleDefinition {function} main function of the module. 
 * It should return a list of components
 * @param deps {mixed[]} dependencies
 */
arcs_module = function (moduleDefinition, deps) {
    var dependencies = [], loadedDependencies = 0, storeComponents, i;

    if (typeof module !== 'undefined') {
        if (module.parent.exports) {
            ARCS = module.exports; //.parent.exports;
        //console.log(module);
        }
    }

    dependencies[0] = ARCS;

    //console.log(ARCS);
    // one of the first problems that may arise is that we should solve dependencies
    // here before launching the application since module definition will depend on it !
    // it will depend wether we are using node.js or require.js !

    if (deps === undefined) { deps = []; }

    storeComponents = function (deps) {
        // coté asynchrone non défini
        //console.log("storing components");
        var mdef, p, actualDep, shimConfig;
        mdef = (typeof moduleDefinition === 'function') ?
                moduleDefinition.apply(this, deps) : moduleDefinition;

        if (mdef === undefined) {
            throw new Error("[ARCS] Your module is undefined. Did you forget to export components?\nCode of module follows:\n"+moduleDefinition);
        }

        //console.log("[ARCS] Loading factories:",mdef);
        for (p in mdef) {
             ARCS.Application.setFactory(ARCS.Application.currentApplication, p, mdef[p]);
        }

        // hack for require.js
        // ARCS is then defined as a require.js module.
        
        // It seems this hack is not needed anymore ! --> Great !
        /*if (ARCS.isInRequire()) {
            define(mdef);
        }*/
    };

    // for each dependency, do:       
    for (i = 0; i < deps.length; i++) {
        if (ARCS.isInNode()) {
            // here this is a synchronous load of the script
            dependencies[i] = require(deps[i]);
        } else {
            // here we should use require
            actualDep = deps[i];
            if (actualDep.name !== undefined) {
                shimConfig = { shim: {} };
                shimConfig.shim[actualDep.name] = { exports: actualDep.exports };
                if (actualDep.deps !== undefined) {
                    shimConfig.shim[actualDep.name].deps = actualDep.deps;
                }
                require.config(shimConfig);
                actualDep = actualDep.name;
            }
            //console.log("[ARCS] Loading dependency ",actualDep);
            
            // since actualDep and i may be moving, we will create a function
            // that creates a function (one more step and it will be currying
            var handleDep = function(depName, index) {
                    return function(dep) {
                        //console.log(depName,"loaded",index);
                        loadedDependencies++;
                        dependencies[index+1] = dep;
                        if (loadedDependencies >= deps.length) {
                            storeComponents(dependencies);
                        }
                    };
            };
            
            
            require([actualDep], 
                handleDep(actualDep,i),
                function (err) {
                    console.error(JSON.stringify(err));
                }
                );
        }
    }

    if (ARCS.isInNode() || deps.length === 0) { storeComponents(dependencies); }
};
