ARCSEditor.ConnectionDialogData = function(app) {
    var application = app;
    var sheetId;
    var connectionObject;
    
    var destinationElement;
    var slotElement;
    var sourceElement;
    var signalElement;

    var addConnection = function () {
        var destination = document.getElementById("connection-destination");
        var slot = document.getElementById("connection-slot");
        var source = document.getElementById("connection-source");
        var signal = document.getElementById("connection-signal");
        ARCSEditor.addConnection(sheetId, 
            { destination: destination.value, slot: slot.value, source: source.value, signal: signal.value }
        );   
        ARCSEditor.Dialog.close();        
    };
    
    
    var storeDestination = function (elt) { destinationElement = elt; };
    var storeSlot = function (elt) { slotElement = elt; };
    var storeSource = function (elt) { sourceElement = elt; };
    var storeSignal = function (elt) { signalElement = elt; }
    
    var populateSlots = function () {        
        return function (elt) { 
            ARCSEditor.populateSlots(slotElement, destinationElement.value); 
        };
    };
    
    var populateSignals = function () {
        return function (elt) {
            var cmp = application.getComponent(sourceElement.value);
            var slist = Object.keys(cmp.signals);
            var i, option;
            signalElement.innerHTML = '';
            for (i = 0; i < slist.length; i++) {
                if (cmp.signals.hasOwnProperty(slist[i])) {
                    option = document.createElement("option");
                    option.text = escape(slist[i]);
                    signalElement.add(option);
                }
            }        
        };
    };
    
    this.selector = "#form-connection";
    
    this.init = function (sheetName,connection) {
        sheetId = sheetName;
        connectionObject = connection;        
    };
    
    this.replacements = [
        { selector: "#connection-destination", run: ARCSEditor.populateComponents },
        { selector: "#connection-destination", run: storeDestination },
        { selector: "#connection-destination", key: "onchange", value: populateSlots() },
        { selector: "#connection-source", run: ARCSEditor.populateComponents },
        { selector: "#connection-source", run: storeSource },
        { selector: "#connection-source", key: "onchange", value: populateSignals() },
        { selector: "#connection-slot", run: storeSlot },
        { selector: "#connection-slot", run: populateSlots() },
        { selector: "#connection-signal", run: storeSignal },
        { selector: "#connection-signal", run: populateSignals() },
        { selector : "#ok", key: "onclick", value: addConnection },
        { selector : "#cancel", key: "onclick", value: ARCSEditor.Dialog.close }
    ];
};