
ARCSEditor.drag = function(ev) {
    if (ev.target.dataset.invokeId !== undefined) {
        ev.dataTransfer.setData("Text", ev.target.dataset.invokeId);
    }
    
    if (ev.target.dataset.linkId !== undefined) {
        ev.dataTransfer.setData("Text", ev.target.dataset.linkId);
    }
};

ARCSEditor.ondragover = function (ev) {
    var dataTransfer = ev.dataTransfer.getData("Text");
    var zone = ev.target.parentNode.parentNode.className;
    
    if (isNaN(parseInt(dataTransfer))) {
        if (dataTransfer.startsWith(zone)) {
            ev.preventDefault();    
        } else {
            return;
        }
    } else {
        if (zone === "connectionlist") {
            ev.preventDefault();
        } else {
            return;
        }
    }
    
    // now we should compute the drop
    
    
};

ARCSEditor.drop = function (ev) {
    ev.preventDefault();
    
    var dataTransfer = ev.dataTransfer.getData("Text");
    /*var zone = ev.target.parentNode.parentNode.className;*/
    
    var source, destination, idSource, idDestination;
    
    // we have to find the sheet we are working on.
    var element = ev.target.parentNode;
    while ( element.tagName.toLowerCase() !== 'div' ) {
        element = element.parentNode;
    }
    
    var sheetName = element.dataset.sheet;
    var sheet = application.getSheet(sheetName);
    
    if (sheet === undefined) {
        return ;
    }
    
    
    //var eltSource = ev.dataTrans
    if (isNaN(parseInt(dataTransfer))) {
        // we are in an invocation zone
        source = element.querySelector("tr[data-invoke-id='"+dataTransfer+"']");
        destination = ev.target.parentNode;
        sourceId = source.dataset.invokeId ;
        destinationId = destination.dataset.invokeId;
        
        sourceClone = source.cloneNode(true);
        destinationClone = destination.cloneNode(true);
        sourceClone.dataset.invokeId = destinationId;
        destinationClone.dataset.invokeId = sourceId;

        var tId = sourceId.split('-')[0];
        var sId = sourceId.split('-')[1];
        var dId = destinationId.split('-')[1];
        
        if (tId === 'preconnectionlist') {
            sheet.swapPreConnections(parseInt(sId), parseInt(dId));            
        }
        if (tId === 'postconnectionlist') {
            sheet.swapPostConnections(parseInt(sId), parseInt(dId));            
        }
        if (tId === 'cleanuplist') {
            sheet.swapCleanups(parseInt(sId), parseInt(dId));            
        }
    } else {
        // we are in a connection zone
        source = element.querySelector("tr[data-link-id='"+dataTransfer+"']");
        destination = ev.target.parentNode;
        sourceId = source.dataset.linkId;
        destinationId = destination.dataset.linkId;

        sourceClone = source.cloneNode(true);
        destinationClone = destination.cloneNode(true);
        sourceClone.dataset.linkId = destinationId;
        destinationClone.dataset.linkId = sourceId;

        sheet.swapConnections(parseInt(sourceId), parseInt(destinationId));              
    }

    // let's swap ?!?
    parent = source.parentNode;
    parent.replaceChild(sourceClone, destination);
    parent.replaceChild(destinationClone, source);
};
