module.exports = function (grunt) {
    "use strict";

// Project configuration.
    grunt.initConfig({
        pkg: grunt.file.readJSON('package.json'),
        jsdoc: {
            dist: {
                src: ['src/*.js', 'docs/Readme.md', 'components/*.js'],
                options: {
                    verbose: true,
                    destination:  'docs/engine',
                    template: 'docs/arcs'
                }
            },
            components : {
                src: ['components/*.js', 'deps/surf/surf.js'],
                options: { 
                    verbose: true,
                    destination: 'docs/components',
                    template: 'docs/arcs',
		    configure: 'docs/jsdoc.conf.json'
                }
            }                
        },
        jslint: {
            dist: {
                src: ['*.js'],
                exclude: ['require.js', 'text.js'],
                directives: {
                    node: true,
                    sloppy: true,
                    plusplus: true,
                    forin: true,
                    devel: true,
                    white: true,
                    predef: ['define', 'arcs_module', 'document']
                    //browser: true,                    
                }
            }
        },
        uglify: {
            build: {
                options: {
                    banner: '/*! <%= pkg.name %> <%= grunt.template.today("yyyy-mm-dd") %> */\n'
                },            
                files: { 
                    'build/arcs.min.js': [
                        'build/arcs.js'
                    ],
                    'build/arcs_browser.js': [
                        'src/arcs_browser.js'
                    ],
                    'build/arcseditor.min.js': [
                        'build/arcseditor.js'
                    ]
                }
            }
        },
        bower: {
            options : {
                verbose: true,
                targetDir: './deps',
                layout: 'byComponent'
            },
            install : {
                
            }
            
        },
	concat: {
            dist: {
                src: [
                        'src/arcs.js',
                        'src/component.js',
                        'src/context.js',
                        'src/invocation.js',
                        'src/connection.js',
                        'src/sheet.js',
                        'src/statemachine.js',
                        'src/application.js',
                        'src/arcs_module.js',
                        'src/exports.js'
                    ],
                dest: 'build/arcs.js'
            }, 
            editor : {
                src: [ 
                        'utils/editor/arcseditor.js',
                        'utils/editor/dragdrop.js',
                        'utils/editor/template.js',
                        'utils/editor/dialog.js',
                        'utils/editor/componentdialog.js',
                        'utils/editor/invocationdialog.js',
                        'utils/editor/connectiondialog.js'
                     ],
                dest: 'build/arcseditor.js'
            }

	}
	

    });

// Load the plugin that provides the "uglify" task.
    grunt.loadNpmTasks('grunt-contrib-uglify');
    grunt.loadNpmTasks('grunt-contrib-concat');
    grunt.loadNpmTasks('grunt-jsdoc');
    grunt.loadNpmTasks('grunt-jslint');
    grunt.loadNpmTasks('grunt-bower-task');


// Default task(s).
    grunt.registerTask('default', ['concat','uglify']);
    grunt.registerTask('lint', ['jslint']);
    grunt.registerTask('doc', ['jsdoc']);
};
