arcs_module(
    function(ARCS) {
        var MessageBox;
        
        MessageBox = ARCS.Component.create(
            function() {
                var widget;
                
                this.setWidget = function (wName) {
                    widget = document.getElementById(wName);
                };
                
                this.displayMessage = function (message) {
                    if (widget === undefined) 
                        return ;
                    widget.innerHTML = message;
                    widget.style.display = 'block';                        
                };
                
                this.hide = function () {
                    if (widget !== undefined) {
                        widget.style.display = 'none';                        
                    }                    
                };
                
            },
            ['setWidget','displayMessage','hide'],
            []            
        );
            
        return { MessageBox: MessageBox };
    }    
);