arcs_module(function(ARCS) {
    var LiveSource;
    LiveSource = ARCS.Component.create(
        function () {
            var context, canvas, video, imageData;
            var defaultWidth = 320;
            var defaultHeight = 240;
            var self = this;
            
            var setUserMedia = function() {
                navigator.getUserMedia = navigator.getUserMedia || navigator.webkitGetUserMedia || navigator.mozGetUserMedia;
                if (navigator.getUserMedia !== undefined) {
                    navigator.getUserMedia({video:true}, 
                        function (stream) {
                            if (window.webkitURL) {
                                video.src = window.webkitURL.createObjectURL(stream);
                            } else if (video.mozSrcObject !== undefined) {
                                video.mozSrcObject = stream;
                            } else {
                                video.src = stream;
                            }
                            self.emit("onReady");
                        },
                        function(error){ console.error("Cannot initialize video component:", error.code); }
                    );
                }
            };
            
            this.grabFrame = function () {
                if ( context === undefined || canvas === undefined || video === undefined)
                    return;
                    
                if (video.readyState === video.HAVE_ENOUGH_DATA) {
                    context.drawImage(video, 0, 0, canvas.width, canvas.height);
                    imageData = context.getImageData(0, 0, canvas.width, canvas.height);
                    this.emit("onImage",imageData);
                }
            };
            
            this.setSize = function(x,y) {
                
            };
            
            this.setWidgets = function (videoId, canvasId) {
                video = document.getElementById(videoId);
                canvas = document.getElementById(canvasId);
                
                if (video === undefined || canvas === undefined) {
                    return;
                }
                context = canvas.getContext("2d");
                var canvasStyle= window.getComputedStyle(canvas);
                canvas.width=parseInt(canvasStyle.width);
                canvas.height=parseInt(canvasStyle.height);
                setUserMedia();
            };
        },
        ['grabFrame','setWidgets'],
        ['onReady','onImage']
    );
    
    return {LiveSource: LiveSource};
});