/************ component dialog **********************/

ARCSEditor.ComponentDialogData = function (app) {
    var application = app;
    var select, cmpValue;
    
    var populateTypes = function (elt) {
        select = elt;
        var i, option;
        var flist = application.getFactoryList();
        elt.innerHTML = '';        
        for (i = 0; i < flist.length; i++) {
            option = document.createElement("option");
            option.text = escape(flist[i]);
            elt.add(option);
        }
        
        statemachineHelp();
    };
    
    var populateType = function(type) {
        return function (elt) {
            select = elt;
            elt.innerHTML = '';
            option = document.createElement("option");
            option.text = type;
            elt.add(option);
        };
    };
        
    var statemachineHelp = function () {
        if (select !== undefined) {
            if (select.value === "StateMachine") {
                if (cmpValue.value == false) {
                        cmpValue.value = '{ "initial": "", "final": "", "transitions" : { "start" : { "token" : "end"} } }';
                }
            } else {
                if (cmpValue.value === '{ "initial": "", "final": "", "transitions" : { "start" : { "token" : "end"} } }') {
                        cmpValue.value = '';
                }
            }
        }
        
    };
    
    var addComponent = function () {
        var type = document.getElementById("component-type");
        var name = document.getElementById("component-name");
        var value = document.getElementById("component-value");
        ARCSEditor.addComponent(type.value, name.value, value.value);   
        ARCSEditor.Dialog.close();        
    };
    
    var changeComponent = function () {
        var name = document.getElementById("component-name");
        var value = document.getElementById("component-value");
        console.log(value.value);
        ARCSEditor.changeComponent(name.value, value.value);
        ARCSEditor.Dialog.close();
    };
    
    this.init = function ( name, type, value ) {
        if (name === undefined) {
            this.replacements = [ 
                { selector : "#component-value", run: function(elt) { cmpValue = elt; } },
                { selector : "select", run: populateTypes },  
                { selector : "select", key: "onchange", value: statemachineHelp },
                { selector : "#ok", key: "onclick", value: addComponent }, 
                { selector : "#cancel", key: "onclick", value: ARCSEditor.Dialog.close }      
            ];
        } else {
            this.replacements = [ 
                { selector : "#component-value", run: function(elt) { cmpValue = elt; } },
                { selector: "select", run: populateType(type) }, 
                { selector: "select", key: "disabled", value: true },
                { selector: "#component-name", key: "value", value: name }, 
                { selector: "#component-name", key: "disabled", value: true }, 
                { selector: "#component-value", key: "value", value: value },
                { selector: "#ok", key: "onclick", value: changeComponent },
                { selector: "#cancel", key: "onclick", value: ARCSEditor.Dialog.close }
            ];
        }
    };
    
    this.selector = "#form-component";     
};

